*** data

* import delimited "DATA.csv"
rename v1 MatchingProbability
rename v2 AmbiguityNeutralProbability 
rename v3 ID
rename v4 Treatment
rename v5 Choose
rename v6 Order
egen newID=group(ID)
drop ID
rename newID ID
forvalues i=1/5 {
gen T`i'=0
replace T`i'=1 if Treatment==`i' // generate treatment dummies
}
gen one=1

* save "data.dta"



*** parametric fitting - comparisons

* fitting: neo-additive, clustered ID
nl (MatchingProbability=({c1}*T1+{c2}*T2+{c3}*T3+{c4}*T4+{c5}*T5)+({s1}*T1+{s2}*T2+{s3}*T3+{s4}*T4+{s5}*T5)*AmbiguityNeutralProbability), vce(cl ID)

display "indexes b and a"
forvalues i=1/5 {
display "b_"`i'  // b
display 1-[s`i']_cons-2*[c`i']_cons
test 1-[s`i']_cons-2*[c`i']_cons=0
display "a_"`i'  // a
display 1-[s`i']_cons
test 1-[s`i']_cons=0
}

display "comparing c across treatments"
forvalues i=2/5 {
test [c1]_cons=[c`i']_cons

}
test [c4]_cons=[c5]_cons

display "comparing s across treatments"
forvalues i=2/5 {
test [s1]_cons=[s`i']_cons
}
test [s4]_cons=[s5]_cons

display "comparing b across treatments"
forvalues i=2/5 {
test 1-[s1]_cons-2*[c1]_cons=1-[s`i']_cons-2*[c`i']_cons
}
test 1-[s4]_cons-2*[c4]_cons=1-[s5]_cons-2*[c5]_cons

display "comparing a across treatments"
forvalues i=2/5 {
test 1-[s1]_cons=1-[s`i']_cons
}
test 1-[s4]_cons=1-[s5]_cons

* fitting: Goldstein & Einhorn, clustered ID
nl (MatchingProbability=({b1}*T1+{b2}*T2+{b3}*T3+{b4}*T4+{b5}*T5)*AmbiguityNeutralProbability^({a1}*T1+{a2}*T2+{a3}*T3+{a4}*T4+{a5}*T5)/(({b1}*T1+{b2}*T2+{b3}*T3+{b4}*T4+{b5}*T5)*AmbiguityNeutralProbability^({a1}*T1+{a2}*T2+{a3}*T3+{a4}*T4+{a5}*T5)+(1-AmbiguityNeutralProbability)^({a1}*T1+{a2}*T2+{a3}*T3+{a4}*T4+{a5}*T5))), vce(cluster ID)

display "comparing b across treatments"
forvalues i=2/5 {
test [b1]_cons=[b`i']_cons
}
test [b4]_cons=[b5]_cons

display "comparing a across treatments"
forvalues i=2/5 {
test [a1]_cons=[a`i']_cons
}
test [a4]_cons=[a5]_cons

* fitting: Prelec 2-parameter, clustered ID
nl (MatchingProbability=(exp(-(-ln(AmbiguityNeutralProbability))^({a1}*T1+{a2}*T2+{a3}*T3+{a4}*T4+{a5}*T5)))^({b1}*T1+{b2}*T2+{b3}*T3+{b4}*T4+{b5}*T5)), vce(cluster ID)

display "comparing b across treatments"
forvalues i=2/5 {
test [b1]_cons=[b`i']_cons
}
test [b4]_cons=[b5]_cons

display "comparing a across treatments"
forvalues i=2/5 {
test [a1]_cons=[a`i']_cons
}
test [a4]_cons=[a5]_cons

* fitting: Prelec 1-parameter, clustered ID
nl (MatchingProbability=exp(-(-ln(AmbiguityNeutralProbability))^({a1}*T1+{a2}*T2+{a3}*T3+{a4}*T4+{a5}*T5))), vce(cluster ID)

display "comparing a across treatments"
forvalues i=2/5 {
test [a1]_cons=[a`i']_cons
}
test [a4]_cons=[a5]_cons

* fitting: Tversky & Kahneman, clustered ID
nl (MatchingProbability=AmbiguityNeutralProbability^({c1}*T1+{c2}*T2+{c3}*T3+{c4}*T4+{c5}*T5)/((AmbiguityNeutralProbability^({c1}*T1+{c2}*T2+{c3}*T3+{c4}*T4+{c5}*T5)+(1-AmbiguityNeutralProbability)^({c1}*T1+{c2}*T2+{c3}*T3+{c4}*T4+{c5}*T5))^(1/({c1}*T1+{c2}*T2+{c3}*T3+{c4}*T4+{c5}*T5)))), vce(cluster ID) initial(c1 0.28 c2 0.28 c3 0.28 c4 0.28 c5 0.28)

display "comparing a across treatments"
forvalues i=2/5 {
test [c1]_cons=[c`i']_cons
}
test [c4]_cons=[c5]_cons



*** parametric fitting - by treatments

sort Treatment

* fitting: neo-additive, clustered ID
forvalues j=1/5 {
	display "treatment `j'"
	reg MatchingProbability one AmbiguityNeutralProbability if Treatment==`j', nocon vce(cl ID)
	est stats
}

* fitting: Goldstein & Einhorn, clustered ID
forvalues j=1/5 {
	display "treatment `j'"
	nl (MatchingProbability={b}*AmbiguityNeutralProbability^{a}/({b}*AmbiguityNeutralProbability^{a}+(1-AmbiguityNeutralProbability)^{a})) if Treatment==`j', vce(cluster ID)
	est stats
}

* fitting: Prelec 2-parameter, clustered ID
forvalues j=1/5 {
	display "treatment `j'"
	nl (MatchingProbability=(exp(-(-ln(AmbiguityNeutralProbability))^{a}))^{b}) if Treatment==`j', vce(cluster ID)
	est stats
}

* fitting: Prelec 1-parameter, clustered ID
forvalues j=1/5 {
	display "treatment `j'"
	nl (MatchingProbability=exp(-(-ln(AmbiguityNeutralProbability))^{a})) if Treatment==`j', vce(cluster ID)
	est stats
}

* fitting: Tversky & Kahneman, clustered ID
forvalues j=1/5 {
	display "treatment `j'"
	nl (MatchingProbability=AmbiguityNeutralProbability^{c}/((AmbiguityNeutralProbability^{c}+(1-AmbiguityNeutralProbability)^{c})^(1/{c}))) if Treatment==`j', vce(cluster ID) initial(c 0.28)
	est stats
}


*** individual fitting

* import delimited "DATA_add.csv"
rename v1 MatchingProbability
rename v2 AmbiguityNeutralProbability 
rename v3 ID
rename v4 Treatment
* append "data.dta"
drop Choose Order T1 T2 T3 T4 T5 one
* save "data_added.dta"

quietly gen GE_a=.
quietly gen GE_b=.
quietly gen TK_c=.

forvalues i=1/66 {
	forvalues j=1/5 {	
			* Goldstein & Einhorn
			quietly nl (MatchingProbability=exp({b})*AmbiguityNeutralProbability^exp({a})/(exp({b})*AmbiguityNeutralProbability^exp({a})+(1-AmbiguityNeutralProbability)^exp({a}))) if ID==`i'&Treatment==`j'
			mat parameters=e(b)
			quietly replace GE_a=exp(parameters[1,2]) if ID==`i'&Treatment==`j'
			quietly replace GE_b=exp(parameters[1,1]) if ID==`i'&Treatment==`j'
			* Tversky & Kahneman
			quietly nl (MatchingProbability=AmbiguityNeutralProbability^(exp({c})+0.28)/(AmbiguityNeutralProbability^(exp({c})+0.28)+(1-AmbiguityNeutralProbability)^(exp({c})+0.28))^(1/(exp({c})+0.28)))  if ID==`i'&Treatment==`j'
			mat parameters=e(b)
			quietly replace TK_c=exp(parameters[1,1])+0.28 if ID==`i'&Treatment==`j'
	}
}

collapse (mean) GE_a GE_b TK_c, by(ID Treatment)
* save "individual fittings (constraints) _ GE TK.dta"

* use "data_added.dta"
drop if AmbiguityNeutralProbability==0

quietly gen P2_a=.
quietly gen P2_b=.
quietly gen P1_a=.

forvalues i=1/66 {
	forvalues j=1/5 {	
			* Prelec 2-parameter
			quietly nl (MatchingProbability=(exp(-(-ln(AmbiguityNeutralProbability))^exp({a})))^exp({b})) if ID==`i'&Treatment==`j'
			mat parameters=e(b)
			quietly replace P2_a=exp(parameters[1,1]) if ID==`i'&Treatment==`j'
			quietly replace P2_b=exp(parameters[1,2]) if ID==`i'&Treatment==`j'
			* Prelec 1-parameter
			quietly nl (MatchingProbability=(exp(-(-ln(AmbiguityNeutralProbability))^exp({a})))) if ID==`i'&Treatment==`j'
			mat parameters=e(b)
			quietly replace P1_a=exp(parameters[1,1]) if ID==`i'&Treatment==`j'
				}
}

collapse (mean) P2_a P2_b P1_a, by(ID Treatment)
* save "individual fittings (constraints) _ P2 P1.dta"

* copy these estimates into MATLAB
